/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.configurations.processor;

import com.aptana.configurations.ConfigurationsPlugin;
import com.aptana.configurations.processor.AbstractConfigurationProcessor;
import com.aptana.core.logging.IdeLog;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationStatus
implements JSON.Convertible {
    public static final String UNKNOWN = "unknown";
    public static final String OK = "ok";
    public static final String PROCESSING = "processing";
    public static final String INCOMPLETE = "incomplete";
    public static final String ERROR = "error";
    public static final String STATUS = "status";
    private static final String PREF_PREFIX = "configuration.status.";
    private Map<String, String> attributes;
    private String configurationProcessorId;
    private AbstractConfigurationProcessor processor;
    private Set<String> notificationSet;
    private IStatus additionalStatus;

    public ConfigurationStatus(String configurationProcessorId, String status, AbstractConfigurationProcessor processor) {
        this.configurationProcessorId = configurationProcessorId;
        this.processor = processor;
        this.attributes = new HashMap<String, String>();
        this.notificationSet = new HashSet<String>(3);
        this.setAttribute(STATUS, status);
        this.load();
    }

    public ConfigurationStatus(String configurationProcessorId, AbstractConfigurationProcessor processor) {
        this(configurationProcessorId, UNKNOWN, processor);
    }

    public void setStatus(String status) {
        this.setAttribute(STATUS, status);
    }

    public String getStatus() {
        return this.getAttribute(STATUS);
    }

    public void setAdditionalStatus(IStatus status) {
        this.additionalStatus = status;
    }

    public IStatus getAdditionalStatus() {
        return this.additionalStatus;
    }

    public void setAttribute(String key, String value) {
        if (!(!STATUS.equals(key) || UNKNOWN.equals(value) || OK.equals(value) || PROCESSING.equals(value) || ERROR.equals(value) || INCOMPLETE.equals(value))) {
            throw new IllegalArgumentException("The given state is unknown to the ConfigurationStatus (state = " + value + ')');
        }
        this.attributes.put(key, value);
        this.notifyProcessor(key);
    }

    public void removeAttribute(String key) {
        if (STATUS.equals(key)) {
            throw new IllegalArgumentException("The status attribute cannot be removed from this ConfigurationStatus");
        }
        this.attributes.remove(key);
        this.notifyProcessor(key);
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Set<String> getAttributesKeys() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    public String getProcessorId() {
        return this.configurationProcessorId;
    }

    public void store() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.configurations");
        prefs.put(PREF_PREFIX + this.getProcessorId(), JSON.toString(this.attributes));
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ConfigurationsPlugin.getDefault(), (String)"Error while saving the configuration status state", (Throwable)e);
        }
    }

    protected void load() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.configurations");
        if (prefs != null) {
            try {
                String cachedAttributes = prefs.get(PREF_PREFIX + this.getProcessorId(), null);
                if (cachedAttributes != null) {
                    Map map = (Map)JSON.parse((String)cachedAttributes);
                    this.attributes.putAll(map);
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)ConfigurationsPlugin.getDefault(), (String)"Error while loading the configuration status state", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyProcessor(String key) {
        Set<String> set = this.notificationSet;
        synchronized (set) {
            this.notificationSet.clear();
            this.notificationSet.add(key);
            this.processor.notifyListeners(this.notificationSet);
        }
    }

    public void fromJSON(Map map) {
        this.attributes.putAll(map);
    }

    public void toJSON(JSON.Output out) {
        for (String key : this.attributes.keySet()) {
            String value = this.attributes.get(key);
            try {
                Object outputObject = JSON.parse((String)value);
                out.add(key, outputObject);
            }
            catch (Exception e) {
                out.add(key, (Object)value);
            }
        }
    }
}

